<?php
session_start();
if (!isset($_SESSION['USE_ID'])) {
    // Redirect to login page if not logged in
    header('Location: login.php');
    exit;
}

// Include MySQL connection script
include "Connections/connect_mysql.php";

$errorMessage = "";  // Initialize error message

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userId = $_SESSION['USE_ID'];
    $newPassword = $_POST['new_password'];
    $confirmPassword = $_POST['confirm_password'];

    // Perform server-side validation
    $containsDigit = preg_match('/[0-9]/', $newPassword);
    $containsLowercase = preg_match('/[a-z]/', $newPassword);
    $containsUppercase = preg_match('/[A-Z]/', $newPassword);
    $containsSpecialChar = preg_match('/[^a-zA-Z\d]/', $newPassword);
    $isLengthValid = strlen($newPassword) >= 8;

    if ($newPassword != $confirmPassword) {
        $errorMessage = "รหัสผ่านและรหัสผ่านยืนยันไม่ตรงกัน<br>";
    }
    if (!$containsDigit) {
        $errorMessage .= "รหัสผ่านต้องมีตัวเลขอย่างน้อยหนึ่งตัว<br>";
    }
    if (!$containsLowercase) {
        $errorMessage .= "รหัสผ่านต้องมีตัวพิมพ์เล็กอย่างน้อยหนึ่งตัว<br>";
    }
    if (!$containsUppercase) {
        $errorMessage .= "รหัสผ่านต้องมีตัวพิมพ์ใหญ่อย่างน้อยหนึ่งตัว<br>";
    }
    if (!$containsSpecialChar) {
        $errorMessage .= "รหัสผ่านต้องมีอักขระพิเศษอย่างน้อยหนึ่งตัว<br>";
    }
    if (!$isLengthValid) {
        $errorMessage .= "รหัสผ่านต้องมีความยาวอย่างน้อย 8 ตัวอักษร<br>";
    }

    if (empty($errorMessage)) {
        // Update password in the database
        $sql = "UPDATE `tbl_user` SET `USE_PASS` = '{$newPassword}' WHERE `USE_ID` = '{$userId}'";
        if (mysql_query($sql)) {
            echo "<script>alert('รหัสผ่านได้ถูกเปลี่ยนแล้ว'); window.location = 'index.php';</script>";
        } else {
            echo "<script>alert('เกิดข้อผิดพลาดในการเปลี่ยนรหัสผ่าน');</script>";
        }
    }

    mysql_close($c);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>เปลี่ยนรหัสผ่าน</title>
    <link href="vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="vendors/nprogress/nprogress.css" rel="stylesheet">
    <link href="vendors/animate.css/animate.min.css" rel="stylesheet">
    <link href="build/css/custom.min.css" rel="stylesheet">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="ajax/function.js"></script> 
    <style>
        .error-message {
            color: red;
            margin-bottom: 10px;
        }
        .valid-message {
            color: green;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<div class="modal-dialog modal-dialog-centered modal-sm">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">เปลี่ยนรหัสผ่าน</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form id="passwordForm" action="change_password.php" method="post" onsubmit="return validatePassword();">
                <div class="form-group">
                    <label for="new_password">รหัสผ่านใหม่:</label>
                    <input type="password" class="form-control" id="new_password" name="new_password" required>
                </div>
                <div class="form-group">
                    <label for="confirm_password">ยืนยันรหัสผ่านใหม่:</label>
                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                </div>
                <div id="password_error" class="error-message"></div>
                <button type="submit" class="btn btn-primary btn-block">เปลี่ยนรหัสผ่าน</button>
            </form>
        </div>
    </div>
</div>


</body>
</html>
